﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using LiczbyZespolone;

namespace TestProject1
{
    [TestClass]
    public class ComplexTest
    {
        [TestMethod]
        public void Equals_DwieTakieSameLiczbyZespolone_ZwracaTrue()
        {
            //arrange
            var complex1 = new Complex(3, 3);
            var complex2 = new Complex(3, 3);

            //act
            var saRowne = complex1.Equals(complex2);

            //assert
            Assert.IsTrue(saRowne);
        }

        [TestMethod]
        public void Radius_LiczbaZespolona_ZwracaPoprawnyPromien()
        {
            //arrange
            var c = new Complex(4, 3);

            //act
            var modul = c.Radius;

            //assert
            Assert.AreEqual(modul, 5);
        }

        [TestMethod]
        public void Dodawanie_DwieLiczbyZespolone_ZwracaPoprawnyWynik()
        {
            //arrange
            var c1 = new Complex(1, 2);
            var c2 = new Complex(4, 5);

            //act
            var wynik = c1 + c2;

            //assert
            Assert.AreEqual(wynik.Real, 5);
        }

        [TestMethod]
        [ExpectedException(typeof(Exception))]
        public void Dzielenie_NormaDzielnikaZero_WyrzucaWyjatek()
        {
            var dzielnik = new Complex(0, 0);
            var dzielna = new Complex(1, 2);

            var wynik = dzielna / dzielnik;
        }
    }
}
